import flash.filters.BevelFilter;
import flash.filters.BitmapFilter;
import flash.filters.BlurFilter;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import OOFilterBaseCmp;
/**
 * ...
 * @author 
 */
class OOFilter extends OOFilterBaseCmp
{
	////////////////////////////
	// GROUP : drop shadow
	///////////////////////////
	private var _dropShadowDistance:Number;
	
	private var _dropShadowAngle:Number;
	
	private var _dropShadowBlurX:Number;
	
	private var _dropShadowBlurY:Number;
	
	private var _dropShadowAlpha:Number;
	
	private var _dropShadowColor:Number;
	
	private var _dropShadowIsInner:Boolean;
	
	private var _dropShadowKnockout:Boolean;
	
	private var _dropShadowQuality:Number;
	
	private var _dropShadowFilterEnabled:Boolean;
	
	private var _dropShadowStrength:Number;
	
	////////////////////////////
	// GROUP : blur filter
	////////////////////////////
	private var _blurFilterEnabled:Boolean;
	
	private var _blurBlurX:Number;
	
	private var _blurBlurY:Number;
	
	private var _blurQuality:Number;
	
	///////////////////////////
	// GROUP : glow filter
	///////////////////////////
	private var _glowFilterEnabled:Boolean;
	
	private var _glowAlpha:Number;
	
	private var _glowBlurX:Number;
	
	private var _glowBlurY:Number;
	
	private var _glowColor:Number;
	
	private var _glowIsInner:Boolean;
	
	private var _glowKnockout:Boolean;
	
	private var _glowQuality:Number;
	
	private var _glowStrength:Number;
	
	///////////////////////////
	// GROUP : bevel filter
	///////////////////////////
	private var _bevelFilterEnabled:Boolean;
	
	private var _bevelAngle:Number;
	
	private var _bevelBlurX:Number;
	
	private var _bevelBlurY:Number;
	
	private var _bevelDistance:Number;
	
	private var _bevelHighlightAlpha:Number;
	
	private var _bevelHighLightColor:Number;
	
	private var _bevelKnockout:Boolean;
	
	private var _bevelQuality:Number;
	
	private var _bevelShadowAlpha:Number;
	
	private var _bevelShadowColor:Number;
	
	private var _bevelStrength:Number;
	
	private var _bevelType:String;
	
	public function OOFilterDropShadow() 
	{
		super();
	}
	
	public function _initAfterRegister(){
 		super._initAfterRegister();
	}
	
	/**
	 * create and return a filter array
	 * @return the created bitmap filter
	 */
	public function createFilters():Array
	{
		var res:Array = new Array();
		
		if (_dropShadowFilterEnabled == true)
		{
			res.push(new DropShadowFilter(this.dropShadowDistance, this.dropShadowAngle, this.dropShadowColor, this.dropShadowAlpha, this.dropShadowBlurX, this.dropShadowBlurY, this.dropShadowStrength, this.dropShadowQuality, this.dropShadowIsInner));
		}
		
		if (_blurFilterEnabled == true)
		{
			res.push(new BlurFilter(this.blurBlurX, this.blurBlurY, this.blurQuality));
		}
		
		if (_glowFilterEnabled == true)
		{
			res.push(new GlowFilter(this.glowColor, this.glowAlpha, this.glowBlurX, this.glowBlurY, this.glowStrength, this.glowQuality, this.glowIsInner, this.glowKnockout));
		}
		
		if (_bevelFilterEnabled == true)
		{
			res.push(new BevelFilter(this.bevelDistance, this.bevelAngle, this.bevelHighLightColor, this.bevelHighlightAlpha, this.bevelShadowColor, this.bevelShadowAlpha, this.bevelBlurX, this.bevelBlurY, this.bevelStrength, this.bevelQuality, this.bevelType, this.bevelKnockout));
		}
		
		return res;
	}

	
	
	/////////////////////
	// GROUP : drop shadow
	////////////////////
	
	public function get dropShadowDistance():Number { return _dropShadowDistance; }
	
	public function set dropShadowDistance(value:Number):Void 
	{
		_dropShadowDistance = value;
		this.applyFilter();
	}
	
	public function get dropShadowBlurX():Number { return _dropShadowBlurX; }
	
	public function set dropShadowBlurX(value:Number):Void 
	{
		_dropShadowBlurX = value;
		this.applyFilter();
	}
	
	public function get dropShadowBlurY():Number { return _dropShadowBlurY; }
	
	public function set dropShadowBlurY(value:Number):Void 
	{
		_dropShadowBlurY = value;
		this.applyFilter();
	}
	
	public function get dropShadowAlpha():Number { return _dropShadowAlpha; }
	
	public function set dropShadowAlpha(value:Number):Void 
	{
		_dropShadowAlpha = value;
		this.applyFilter();
	}
	
	public function get dropShadowColor():Number { return _dropShadowColor; }
	
	public function set dropShadowColor(value:Number):Void 
	{
		_dropShadowColor = value;
		this.applyFilter();
	}
	
	public function get dropShadowIsInner():Boolean { return _dropShadowIsInner; }
	
	public function set dropShadowIsInner(value:Boolean):Void 
	{
		_dropShadowIsInner = value;
		this.applyFilter();
	}
	
	public function get dropShadowKnockout():Boolean { return _dropShadowKnockout; }
	
	public function set dropShadowKnockout(value:Boolean):Void 
	{
		_dropShadowKnockout = value;
		this.applyFilter();
	}
	
	public function get dropShadowQuality():Number { return _dropShadowQuality; }
	
	public function set dropShadowQuality(value:Number):Void 
	{
		_dropShadowQuality = value;
		this.applyFilter();
	}
	
	public function get dropShadowStrength():Number { return _dropShadowStrength; }
	
	public function set dropShadowStrength(value:Number):Void 
	{
		_dropShadowStrength = value;
		this.applyFilter();
	}
	
	public function get dropShadowAngle():Number { return _dropShadowAngle; }
	
	public function set dropShadowAngle(value:Number):Void 
	{
		_dropShadowAngle = value;
		this.applyFilter();
	}
	
	public function get dropShadowFilterEnabled():Boolean { return _dropShadowFilterEnabled; }
	
	public function set dropShadowFilterEnabled(value:Boolean):Void 
	{
		_dropShadowFilterEnabled = value;
		this.applyFilter();
	}
	
	
	/////////////////////
	// GROUP : blur
	////////////////////
	public function get blurFilterEnabled():Boolean { return _blurFilterEnabled; }
	
	public function set blurFilterEnabled(value:Boolean):Void 
	{
		_blurFilterEnabled = value;
		this.applyFilter();
	}
	
	public function get blurBlurX():Number { return _blurBlurX; }
	
	public function set blurBlurX(value:Number):Void 
	{
		_blurBlurX = value;
		this.applyFilter();
	}
	
	public function get blurBlurY():Number { return _blurBlurY; }
	
	public function set blurBlurY(value:Number):Void 
	{
		_blurBlurY = value;
		this.applyFilter();
	}
	
	public function get blurQuality():Number { return _blurQuality; }
	
	public function set blurQuality(value:Number):Void 
	{
		_blurQuality = value;
		this.applyFilter();
	}
	
	/////////////////////
	// GROUP : glow
	////////////////////
	
	public function get glowFilterEnabled():Boolean { return _glowFilterEnabled; }
	
	public function set glowFilterEnabled(value:Boolean):Void 
	{
		_glowFilterEnabled = value;
		this.applyFilter();
	}
	
	public function get glowAlpha():Number { return _glowAlpha; }
	
	public function set glowAlpha(value:Number):Void 
	{
		_glowAlpha = value;
		this.applyFilter();
	}
	
	public function get glowBlurX():Number { return _glowBlurX; }
	
	public function set glowBlurX(value:Number):Void 
	{
		_glowBlurX = value;
		this.applyFilter();
	}
	
	public function get glowBlurY():Number { return _glowBlurY; }
	
	public function set glowBlurY(value:Number):Void 
	{
		_glowBlurY = value;
		this.applyFilter();
	}
	
	public function get glowColor():Number { return _glowColor; }
	
	public function set glowColor(value:Number):Void 
	{
		_glowColor = value;
		this.applyFilter();
	}
	
	public function get glowIsInner():Boolean { return _glowIsInner; }
	
	public function set glowIsInner(value:Boolean):Void 
	{
		_glowIsInner = value;
		this.applyFilter();
	}
	
	public function get glowKnockout():Boolean { return _glowKnockout; }
	
	public function set glowKnockout(value:Boolean):Void 
	{
		_glowKnockout = value;
		this.applyFilter();
	}
	
	public function get glowQuality():Number { return _glowQuality; }
	
	public function set glowQuality(value:Number):Void 
	{
		_glowQuality = value;
		this.applyFilter();
	}
	
	public function get glowStrength():Number { return _glowStrength; }
	
	public function set glowStrength(value:Number):Void 
	{
		_glowStrength = value;
		this.applyFilter();
	}
	
	/////////////////////
	// GROUP : bevel
	////////////////////
	
	public function get bevelFilterEnabled():Boolean { return _bevelFilterEnabled; }
	
	public function set bevelFilterEnabled(value:Boolean):Void 
	{
		_bevelFilterEnabled = value;
		this.applyFilter();
	}
	
	public function get bevelAngle():Number { return _bevelAngle; }
	
	public function set bevelAngle(value:Number):Void 
	{
		_bevelAngle = value;
		this.applyFilter();
	}
	
	public function get bevelBlurX():Number { return _bevelBlurX; }
	
	public function set bevelBlurX(value:Number):Void 
	{
		_bevelBlurX = value;
		this.applyFilter();
	}
	
	public function get bevelBlurY():Number { return _bevelBlurY; }
	
	public function set bevelBlurY(value:Number):Void 
	{
		_bevelBlurY = value;
		this.applyFilter();
	}
	
	public function get bevelDistance():Number { return _bevelDistance; }
	
	public function set bevelDistance(value:Number):Void 
	{
		_bevelDistance = value;
		this.applyFilter();
	}
	
	public function get bevelHighlightAlpha():Number { return _bevelHighlightAlpha; }
	
	public function set bevelHighlightAlpha(value:Number):Void 
	{
		_bevelHighlightAlpha = value;
		this.applyFilter();
	}
	
	public function get bevelHighLightColor():Number { return _bevelHighLightColor; }
	
	public function set bevelHighLightColor(value:Number):Void 
	{
		_bevelHighLightColor = value;
		this.applyFilter();
	}
	
	public function get bevelKnockout():Boolean { return _bevelKnockout; }
	
	public function set bevelKnockout(value:Boolean):Void 
	{
		_bevelKnockout = value;
		this.applyFilter();
	}
	
	public function get bevelQuality():Number { return _bevelQuality; }
	
	public function set bevelQuality(value:Number):Void 
	{
		_bevelQuality = value;
		this.applyFilter();
	}
	
	public function get bevelShadowAlpha():Number { return _bevelShadowAlpha; }
	
	public function set bevelShadowAlpha(value:Number):Void 
	{
		_bevelShadowAlpha = value;
		this.applyFilter();
	}
	
	public function get bevelShadowColor():Number { return _bevelShadowColor; }
	
	public function set bevelShadowColor(value:Number):Void 
	{
		_bevelShadowColor = value;
		this.applyFilter();
	}
	
	public function get bevelStrength():Number { return _bevelStrength; }
	
	public function set bevelStrength(value:Number):Void 
	{
		_bevelStrength = value;
		this.applyFilter();
	}
	
	public function get bevelType():String { return _bevelType; }
	
	public function set bevelType(value:String):Void 
	{
		_bevelType = value;
		this.applyFilter();
	}
}