import flash.filters.BitmapFilter;
import flash.filters.DropShadowFilter;
import org.oof.OofBase;
import org.silex.core.ApplicationHooks;
import org.silex.core.Utils;
import org.silex.ui.UiBase;

/**
 * ...
 * @author 
 * The base class for all filters. Apply the inheriting filter to all the targeted component using OOFBase method. 
 * It also refresh the components filters when data changes. 
 * It is completed by a OOFilterBaseCmp class that pushes the editableProperties array for use in Silex.
 */
class OOFilterBase extends OofBase
{
	/**
	 * The array of targeted components.
	 */
	private var _filterTargets:Array;
	
	/**
	 * determine if the filter must be applied or not.
	 */
	private var _enabled:Boolean;
	
	
	public function OOFilterBase() 
	{
		
	}
	
	 public function _initAfterRegister(){
 		super._initAfterRegister();
		addListeners();
		//applyFilter();
	}
	
	/**
	 * If the enabled variable is true, for each target in the filterTargets array (if it exists), retrieve the component then
	 * pushes the filter array to add the appliedFilter. Final method, must not be overriden.
	 */
	public function applyFilter():Void
	{
		removeFilter();
		if (this.enabled == true)
		{
			var i:Number;
			trace("apply filters");
			for (i = 0; i < this.filterTargets.length; i++)
			{
				if (silexInstance.application.getPlayerByName(this.filterTargets[i]) != null)
				{
					var player:UiBase = silexInstance.application.getPlayerByName(this.filterTargets[i]);
					var filters:Array = createFilters();
					player.filters = filters;
				}
			}
			
		}
	}
	
	/**
	 * For each target in the filterTargets array, remove the appliedFilter from the target's filter array if it exists.
	 * Final method, must not be overriden.
	 */
	public function removeFilter():Void
	{
		var i:Number;
		for (i = 0; i < this.filterTargets.length; i++)
		{
			if (silexInstance.application.getPlayerByName(this.filterTargets[i]) != null)
			{
				var player:UiBase = silexInstance.application.getPlayerByName(_filterTargets[i]);
				player.filters = [];
			}
		}
	}
	
	/**
	 * Calls the removeFilter, then applyFilter() method when the section changes. 
	 * Useful if the filterTargets array contains filters not always displayed.
	 * @param	event the triggerred event
	 */
	private function onOpenSection(event:Object):Void
	{
		trace("open section");
		applyFilter();
	}
	
	/**
	 * override the onUnload method. Calls the super then call removeFilter(), then removeListeners().
	 */
	public function onUnload():Void
	{
		super.onUnload();
		removeFilter();
		removeListeners();
	}
	
	/**
	 * add listeners for openSection event.
	 */
	private function addListeners():Void
	{
		silexInstance.application.addEventListener("allPlayersLoaded", Utils.createDelegate(this, onOpenSection));
	}
	
	/**
	 * remove all the listeners.
	 */
	private function removeListeners():Void
	{
		silexInstance.application.removeEventListener("allPlayersLoaded", Utils.removeDelegate(this, onOpenSection));
	}
	
	/**
	 * create and return a BitmapFilter
	 * @return the created bitmap filter
	 */
	public function createFilters():Array
	{
		//abstract method
		return null;
	}
	
	/**
	 * Calls the removeFilter() method, set the filterTargets new value then call the applyFilter() method.
	 */
	public function set filterTargets(value:Array):Void
	{
		removeFilter();
		_filterTargets = value;
		applyFilter();
	}
	
	/**
	 * Calls the removeFilter() method then, set the enabled variable value, then if true, 
	 * call addListeners(), then call the applyFilter() method. Else, call removeListeners().
	 */
	public function set enabled(value:Boolean):Void
	{
		removeFilter();
		_enabled = value;
		
		if (_enabled == true)
		{
			addListeners();
			applyFilter();
		}
		
		else
		{
			removeListeners();
		}
	}
	
	public function get enabled():Boolean
	{
		return _enabled;
	}
	
	public function get filterTargets():Array
	{
		return _filterTargets;
	}
	
}