package pdfGUIWebService;

import org.silex.serverApi.helpers.Env;
import org.silex.serverApi.RootDir;
import org.silex.serverApi.SiteEditor;
import org.silex.serverApi.FileSystemTools;
import org.silex.serverApi.FileSystemItem;

/**
*  This class is the one providing the webservice
*/
class Server
{
	/**
	*  This is a function that one can use for testing purpose. It always returns "Hello Client".
	*/
	public static function sayHello() : String
	{
		return "Hello Client";
	}
	
	/**
	*  This function returns all publications available in contents.
	*/
	public static function listPublications() : Array<String>
	{
		var res = new Array<String>();
		var fs = new FileSystemTools();
		for(f in fs.listFolderContent("contents", true))
		{
			if(f.itemContent != null)
			{
				res.push(f.itemName);
			}
		}
		
		return res;
	}
	
	/**
	*  This function returns all themes available in themes.
	*/
	public static function listThemes() : Array<String>
	{
		var res = new Array<String>();
		var fs = new FileSystemTools();
		for(f in fs.listFolderContent("contents_themes", true))
		{
			if(f.itemContent != null)
			{
				res.push(f.itemName);
			}
		}
		
		return res;
	}

	/**
	*  This function lists all available PDF files. It returns their path relative to the SILEX server's root
	*/
	public static function listPdfFiles() : Array<String>
	{
		var res = new Array<String>();
		var fs = new FileSystemTools();
		for(f in parseFileListResult(fs.listFolderContent("media", true, ["pdf"]), "media"))
		{
			if(f.item.ext.toLowerCase() == "pdf") //filtering doesn't seem to work
				res.push(f.path);
		}
		return res;
	}
	
	/**
	*  Internal function used to generate result of listPdfFiles
	*/
	private static function parseFileListResult(result : Array<FileSystemItem>, basePath : String) : Array<{path : String, item : FileSystemItem}>
	{
		var res = new Array<{path : String, item : FileSystemItem}>();
		for(f in result)
		{
			if(f.itemContent == null) //This is a file, not a directory
			{
				res.push({path : basePath + "/" + f.itemName, item : f});
			} else //this is a directory
			{
				res =  res.concat(parseFileListResult(f.itemContent, basePath + "/" + f.itemName));
			}
		}
		
		return res;
	}
	
	
	/**
	*  Creates a new publication (in contents). Its stage will have the specified width and height.
	*/
	public static function createPublication(id_site : String, width : Int, height: Int)
	{
		var se = new SiteEditor();
		if(se.createWebsite(id_site))
		{
			var siteConf = se.getWebsiteConfig(id_site);
			siteConf.set("layoutStageWidth", Std.string(width));
			siteConf.set("layoutStageHeight", Std.string(height));
			se.writeWebsiteConfig(siteConf, id_site);
		} else
		{
			throw "Couldn't create website";
		}
	}
	
	/**
	*  Used to duplicate a theme into a new publication. Particularly useful for templating.
	*/
	public static function duplicateTheme(themeName : String, newName : String)
	{
		var se = new SiteEditor();
		if(untyped se.duplicateWebsite(themeName, newName) == "")
			return true;
		else
			throw "Couldn't duplicate theme";
	}
	
	/**
	* This function allows you to know if the specified publication is set with hasCover and hasDoublePage.
	*/
	public static function basicInfoOnWebsite(id_site : String) : {hasCover : Bool, hasDoublePages : Bool}
	{
		var ps : org.silex.publication.PublicationStructureModel;
		try
		{
			ps = org.silex.publication.PublicationStructureParser.xml2PS(Xml.parse(php.io.File.getContent("contents/" + id_site + "/structure.xml")));
		}
		catch(e:Dynamic)
		{
			return null;
		}
		
		return {hasCover : ps.hasCover, hasDoublePages : ps.hasDoublePages};
	}
	
	/**
	*  This function returns the path to SWFTools. This path is read from plugins/pdfImport/confSWFTools.
	*/
	public static function getPathToSWFTools() : String
	{
		try
		{
			var conf = new org.silex.serverApi.ConfigEditor();
			var res = conf.readConfigFile("conf/plugins_server.php", "phparray");
			return res.get("pathToSWFTools");
		}
		catch(e : Dynamic)
		{
			return "";
		}
	}
}
