import js.Dom;
import js.Lib;

using StringTools;

class PDFGUI
{
	//These variables store references to HTML elements.
	public static var submitButtonEl : js.Button;
	public static var pathToFileEl : js.Dom.Text;
	public static var importAllEl : js.Dom.Radio;
	public static var importRangeEl : js.Dom.Radio;
	public static var firstPageToExtractEl : js.Dom.Text;
	public static var lastPageToExtractEl : js.Dom.Text;
	public static var publicationNameEl : js.Dom.Text;
	public static var pageLeftOffsetXEl : js.Dom.Text;
	public static var pageLeftOffsetYEl : js.Dom.Text;
	public static var pageRightOffsetXEl : js.Dom.Text;
	public static var pageRightOffsetYEl : js.Dom.Text;
	public static var pageWidthEl : js.Dom.Text;
	public static var pageHeightEl : js.Dom.Text;
	public static var namePrefixEl : js.Dom.Text;
	public static var hasCoverEl : js.Dom.Checkbox;
	public static var hasDoublePagesEl : js.Dom.Checkbox;
	public static var firstSilexPageEl : js.Dom.Checkbox;
	public static var importAsSWFEl : js.Dom.Radio;
	public static var importAsJPGEl : js.Dom.Radio;
	public static var layerNameEl : js.Dom.Text;
	public static var swfDirectoryEl : js.Dom.Text;
	public static var pageNameEl : js.Dom.Text;
	public static var pathToSWFToolsEl : js.Dom.Text;
	public static var createNewPublicationEl : js.Dom.Button;
	public static var importIntoPublicationEl : js.Dom.Button;
	public static var newPublicationNamePromptEl : js.Dom.HtmlDom;
	public static var newPublicationNameValueEl : js.Dom.Text;
	public static var openFTPEl : js.Dom.Button;
	public static var refreshPDFListEl : js.Dom.Button;
	public static var themeNameEl : js.Dom.Text;
	
	public static var divFormImportEl : js.Dom.HtmlDom;
	public static var divProgressEl : js.Dom.HtmlDom;
	
	public static var stageWidth : Int;
	public static var stageHeight : Int;

	public static var serviceURL : String;
	static var actualPage = 1;
	static var startPage : Int;
	static var endPage : Float;
	static var silexPage : Int = 1;
	static var newPublicationMode = false;
	static var pathToSWFTools : String = '';
	
	static var urlBase: String;
	static var mode : InterfaceMode ;
	static var PDFGUI_WEBSERVICE_URL : String;
	static inline var PDF2SWF_DIR : String  = "PDF2SWF.phpdir?";
	static inline var PDFGUI_WEBSERVICE_INDEX : String  = "PDFGUIWebService.phpdir/index.php";
	static inline var PLUGIN_DIR : String = "plugins/pdfImport/";
	//static inline var PLUGIN : String = "plugin";
	//static inline var STANDALONE : String = "standalone";
	
	static inline var RESIZE_IMAGE_SIMPLE_SCRIPT_BASE_PATH :String = "cgi/scripts/get_resized_image.php?scale=noborder&width=80&height=106&file=";
	static inline var RESIZE_IMAGE_DOUBLE_SCRIPT_BASE_PATH :String = "cgi/scripts/get_resized_image.php?scale=noborder&width=160&height=106&file=";
	
	
	/**
	*  Application's Entry point
	*/
	public static function main(): Void
	{
		//Reference to HTML elements.
		submitButtonEl = untyped Lib.document.getElementById("submitImportPDF");
		pathToFileEl = untyped Lib.document.getElementById("pathToPDF");
		importAllEl = untyped Lib.document.getElementById("importAll");
		importRangeEl = untyped Lib.document.getElementById("importRange");
		firstPageToExtractEl = untyped Lib.document.getElementById("firstPageToExtract");
		lastPageToExtractEl = untyped Lib.document.getElementById("lastPageToExtract");
		divFormImportEl = untyped Lib.document.getElementById("formImport");
		pageLeftOffsetXEl = untyped Lib.document.getElementById("pageLeftOffsetX");
		pageLeftOffsetYEl = untyped Lib.document.getElementById("pageLeftOffsetY");
		pageRightOffsetXEl = untyped Lib.document.getElementById("pageRightOffsetX");
		pageRightOffsetYEl = untyped Lib.document.getElementById("pageRightOffsetY");
		pageWidthEl = untyped Lib.document.getElementById("pageWidth");
		pageHeightEl = untyped Lib.document.getElementById("pageHeight");
		namePrefixEl = untyped Lib.document.getElementById("namePrefix");
		hasCoverEl = untyped Lib.document.getElementById("hasCover");
		hasDoublePagesEl = untyped Lib.document.getElementById("hasDoublePages");
		divProgressEl = untyped Lib.document.getElementById("progress");
		firstSilexPageEl = untyped Lib.document.getElementById("firstSilexPage");
		importAsSWFEl = untyped Lib.document.getElementById("importAsSWF");		
		importAsJPGEl = untyped Lib.document.getElementById("importAsJPG");
		layerNameEl = untyped Lib.document.getElementById("layerName");
		swfDirectoryEl = untyped Lib.document.getElementById("swfDirectory");
		pageNameEl = untyped Lib.document.getElementById("pageName");
		pathToSWFToolsEl = untyped Lib.document.getElementById("pathToSWFTools");
		createNewPublicationEl = untyped Lib.document.getElementById("createNewPublication");
		importIntoPublicationEl = untyped Lib.document.getElementById("importIntoPublication");
		newPublicationNameValueEl = untyped Lib.document.getElementById("NewPublicationNameValue");
		//openFTPEl = untyped Lib.document.getElementById("openFTP");
		//refreshPDFListEl = untyped Lib.document.getElementById("refreshPDFList");
		themeNameEl = untyped Lib.document.getElementById("themeName");
		
		// Called to find the mode with which we are calling the script. It also fills the corresponding urlBase value
		initModeAndPath();
		
		serviceURL = urlBase + PLUGIN_DIR + PDF2SWF_DIR;
		PDFGUI_WEBSERVICE_URL = urlBase + PLUGIN_DIR + PDFGUI_WEBSERVICE_INDEX;
		
		//begin populating publication list and pdf files list
		//loadPublications();
		loadPdfFiles();
		loadThemes();
		
		//Setting the handler on the buttons
		untyped submitButtonEl.onclick = handlerSubmit;
		//untyped refreshPDFListEl.onclick = handlerRefreshPDFList;
	
		untyped pageWidthEl.onchange = handlerDimensionsChange;
		untyped pageHeightEl.onchange = handlerDimensionsChange;
		
		// If used in plugin mode: sets the FTP handler on the openFTP button, and sets refresh pdf list handler on the refreshPDFList button
		switch(mode) {
			case plugin:
				openFTPEl = untyped Lib.document.getElementById("openFTP");
				refreshPDFListEl = untyped Lib.document.getElementById("refreshPDFList");
				untyped openFTPEl.onclick = handlerOpenFTP;
				untyped refreshPDFListEl.onclick = handlerRefreshPDFList;
			case standalone:
		};

		//Setting handler on publicationname
		untyped newPublicationNameValueEl.onchange = handlerPublicationNameChange;
		untyped newPublicationNameValueEl.onkeyup = handlerPublicationNameChangeRealTime;

		loadSWFPath();
	}
	
	/**
	* Called to know if the script is used by the standalone or plugin interface
	* updates urlBase value to be in server root directory
	* updates mode to "standalone" or "plugin"
	*/
	private static function initModeAndPath() {
		//gets the URL
		var url : String = Lib.window.location.pathname; 
		
		//checks if plunginDir is included in the URL
		if (url.indexOf(PLUGIN_DIR) >= 0)
		{
			urlBase = "../../";
			mode = InterfaceMode.standalone;			
		} else {
			urlBase = "";
			mode = InterfaceMode.plugin;			
		};
	}

	/**
	* Called to load the pathToSWFTools from server
	*/
	private static function loadSWFPath()
	{
		var url = PDFGUI_WEBSERVICE_URL;
		var cnx = haxe.remoting.HttpAsyncConnection.urlConnect(url);
		//untyped console.log("On my way to load SWFPath");
		cnx.Service.getPathToSWFTools.call([], handlerLoadSWFPath);
	}
	
	private static function handlerLoadSWFPath(res : String)
	{
		//untyped console.log("Received SWFPath " + res);
		pathToSWFTools = res;
	}
	
	/**
	*  Event handler.
	*/
	private static function handlerRefreshPDFList()
	{
		loadPdfFiles();
	}
	
	/**
	*  Event handler.
	*/
	private static function handlerOpenFTP()
	{
		untyped silexJsObj.pop("plugins/ftpClient/FtpClient.php", 653, 313);
	}
	
	private static function handlerPublicationNameChangeRealTime()
	{
		namePrefixEl.value = newPublicationNameValueEl.value + "_imported";
		swfDirectoryEl.value = "media/" + newPublicationNameValueEl.value + "/pdfImport/";		
	}
	
	/**
	*  Event handler.
	*/
	private static function handlerPublicationNameChange()
	{
		//Lock changes while getting info
		hasDoublePagesEl.disabled = true;
		hasCoverEl.disabled = true;
		var url = PDFGUI_WEBSERVICE_URL;
		var cnx = haxe.remoting.HttpAsyncConnection.urlConnect(url);
//		Lib.document.getElementById("progressText").innerHTML = "Creating publication";
		cnx.Service.basicInfoOnWebsite.call([newPublicationNameValueEl.value], callbackPublicationNameChange);
	}
	
	/**
	*  Called when retrieving basic info from server
	*/
	private static function callbackPublicationNameChange(res : {hasCover : Bool, hasDoublePages : Bool})
	{
		//Unlock changes
		hasDoublePagesEl.disabled = false;
		hasCoverEl.disabled = false;
		if(res != null)
		{
			hasCoverEl.checked = res.hasCover;
			hasDoublePagesEl.checked = res.hasDoublePages;
		} else
		{
			hasCoverEl.checked = true;
			hasDoublePagesEl.checked = true;
		}
	}
	
	/**
	*  Event handler.
	*/
	private static function handlerDimensionsChange()
	{
		pageRightOffsetXEl.value = pageWidthEl.value;
		pageRightOffsetYEl.value = "0";
		stageWidth = Std.parseInt(pageWidthEl.value) * 2;
		stageHeight = Std.parseInt(pageHeightEl.value);
	}
	
	/**
	*  This function is called when the user clicks on the submit button
	*/
	static function handlerSubmit()
	{
		//untyped console.log("Begin submit");
//		if(!controlSanity())
//			return;
		//untyped console.log("Passed sanity check");
		divFormImportEl.style.display = "none";
		divProgressEl.style.display = "block";
		//untyped console.log("Just before creating or duplicating");

		//untyped console.log("Now duplicating theme");
		//We have to duplicate the theme into contents
		var url = PDFGUI_WEBSERVICE_URL;
		var cnx = haxe.remoting.HttpConnection.urlConnect(url);
		Lib.document.getElementById("progressText").innerHTML = "Creating publication";
		var res : Array<String>= cnx.Service.duplicateTheme.call([themeNameEl.value ,newPublicationNameValueEl.value]);

		Lib.document.getElementById("progressText").innerHTML = "Starting conversion";
		silexPage = Std.parseInt(firstSilexPageEl.value);
		if(importAllEl.checked)
		{
			actualPage = 1;
			startPage = 1;
			endPage = Math.POSITIVE_INFINITY;
			//untyped console.log("Just before converting");
			convertPage(actualPage);
		} else
		{
			startPage = Std.parseInt(firstPageToExtractEl.value);
			endPage = Std.parseInt(lastPageToExtractEl.value);
			actualPage = startPage;
			//untyped console.log("Just before converting");
			convertPage(startPage);
		}
	}
	
	/**
	*  Controls if the user has correctly entered all informations
	*/
	static function controlSanity() : Bool
	{
		pathToFileEl.style.backgroundColor = "white";
		importAllEl.style.backgroundColor = "white";
		importRangeEl.style.backgroundColor = "white";
		publicationNameEl.style.backgroundColor = "white";			
		firstPageToExtractEl.style.backgroundColor = "white";
		lastPageToExtractEl.style.backgroundColor = "white";
		pageLeftOffsetXEl.style.backgroundColor = "white";
		pageLeftOffsetYEl.style.backgroundColor = "white";
		pageRightOffsetXEl.style.backgroundColor = "white";
		pageRightOffsetYEl.style.backgroundColor = "white";
		pageWidthEl.style.backgroundColor = "white";
		pageHeightEl.style.backgroundColor = "white";
		namePrefixEl.style.backgroundColor = "white";
		
		var errs : Array<js.Dom.HtmlDom> = new Array<js.Dom.HtmlDom>();
		if(pathToFileEl.value == "")
		{
			errs.push(pathToFileEl);
		}
		
		if(!importAllEl.checked && !importRangeEl.checked)
		{
			errs.push(importAllEl);
			errs.push(importRangeEl);
		}
	
		if(publicationNameEl.value == "")
		{
			errs.push(publicationNameEl);
		}

		if(importRangeEl.checked)
		{
			if(firstPageToExtractEl.value == "")
			{
				errs.push(firstPageToExtractEl);
			}
			
			if(lastPageToExtractEl.value == "")
			{
				errs.push(lastPageToExtractEl);
			}
		}
		
		if(pageLeftOffsetXEl.value == "")
			errs.push(pageLeftOffsetXEl);
		if(pageLeftOffsetYEl.value == "")
			errs.push(pageLeftOffsetYEl);
		if(pageRightOffsetXEl.value == "")
			errs.push(pageRightOffsetXEl);
		if(pageRightOffsetYEl.value == "")
			errs.push(pageRightOffsetYEl);
		if(pageWidthEl.value == "")
			errs.push(pageWidthEl);
		if(pageHeightEl.value == "")
			errs.push(pageHeightEl);
		if(namePrefixEl.value == "")
			errs.push(namePrefixEl);
		
		for(el in errs)
		{
			el.style.backgroundColor = "red";
		}
		
		//untyped console.log(errs);
		return !(errs.length > 0);
	}
	
	/**
	*  This function is called to convert a page.
	*/
	static function convertPage(page : Int)
	{
		var h = new haxe.Http(serviceURL + constructOptionString(page,page) + "&action=convertPage");
		h.onData = gotResult;
		h.request(false);
	}
	
	/**
	*  This function is used to construct the GET string depending on the parameters and HTML element's values
	*/
	public static function constructOptionString(page : Int, pageNumber : Int)
	{
		return
		"leftPageXOffset=" + pageLeftOffsetXEl.value.urlEncode()
		+"&leftPageYOffset=" +  pageLeftOffsetYEl.value.urlEncode()
		+ "&rightPageXOffset=" + pageRightOffsetXEl.value.urlEncode()
		+ "&rightPageYOffset=" + pageRightOffsetYEl.value.urlEncode()
		+ "&pageWidth=" + pageWidthEl.value.urlEncode()
		+ "&pageHeight=" + pageHeightEl.value.urlEncode()
		+ "&namePrefix=" + namePrefixEl.value.urlEncode()
		+ "&swfDirectoryName=" + swfDirectoryEl.value.urlEncode()
		+ "&publicationName=" + newPublicationNameValueEl.value.urlEncode()
		+ "&page=" + Std.string(page).urlEncode()
		+ "&pageNumber=" + Std.string(pageNumber).urlEncode()
		+ "&pdfFile=" + pathToFileEl.value.urlEncode()
		+ "&pageName=" + pageNameEl.value.urlEncode()
		+ "&pathToSWFTools=" + pathToSWFTools.urlEncode()
		+ "&hasDoublePages=" + (if(hasDoublePagesEl.checked) "true" else "false")
		+ "&hasCover=" + if(hasCoverEl.checked) "true" else "false";
	}
	
	
	/**
	*  Handler function for the result of a page conversion request to the server
	*/
	static function gotResult(data : String)
	{
		if(data.split(" ")[0] == "Done")
		{
			var progress = Lib.document.getElementById("progressText");
			// 
			var urlPrev = urlBase + RESIZE_IMAGE_SIMPLE_SCRIPT_BASE_PATH + data.split(" ")[1];
			var newEl = Lib.document.createElement("img");
			newEl.setAttribute("src", urlPrev);
			progress.innerHTML = "Converting page" + (Std.int(actualPage)+1) + ".";
			Lib.document.getElementById("largePreview").setAttribute("src", urlPrev);
			//prevs.appendChild(newEl);
		}
		//If the conversion was OK and we know there MAY be some other page
		if(data.split(" ")[0] == "Done" && actualPage+1 <= endPage)
		{
			convertPage(++actualPage);
		} else if(data.split(" ")[0] == "Done" || data == "PageDoesNotExist")
		{
			if(data == "PageDoesNotExist") //In this case the last page did NOT exist so minus 1
				actualPage--;
			var progress = Lib.document.getElementById("progressText");
			progress.innerHTML = "Finished. " + Std.string(actualPage) + " pages converted.<br/>
			Creating Publication's Structure";
			var h = new haxe.Http(serviceURL + constructOptionString(actualPage,actualPage) + "&action=generatePublicationStructure&startPage="
			 																					+ Std.string(startPage)
																								+ "&silexPage=" + Std.string(silexPage)
																								+ "&layerName=" + layerNameEl.value
																								+ "&importFormat=" + if(importAsSWFEl.checked)
																													{
																														"SWF";
																													} else
																													{
																														"JPG";
																													});
			h.onData = publicationStructureDone;
			h.request(false);
		} else
		{
			var progress = Lib.document.getElementById("progressText");
			progress.innerHTML = "Error: " + data.split(" ")[1];
		}
	}
	
	/**
	*  Handler function for the result of a publication structure creation.
	*/
	static function publicationStructureDone(data : String)
	{
		var progress = Lib.document.getElementById("progressText");
		progress.innerHTML = "PublicationStructure generated. " + Std.string(actualPage) + " pages generated.<br/><a href='" + urlBase + "?/" + newPublicationNameValueEl.value + "#/'>Access publication.</a>";	
		Lib.document.getElementById("largePreview").style.display = "none";
		var urls = data.split("\r");
		for(i in 0...urls.length)
		{
			var nel = Lib.document.createElement("img");
			nel.setAttribute("src", urlBase + RESIZE_IMAGE_DOUBLE_SCRIPT_BASE_PATH + urls[i]);
			Lib.document.getElementById("progressPreviews").appendChild(nel);
		}
	}
	
/*	static function loadPublications()
	{
		var url = urlBase + PLUGIN_DIR + "PDFGUIWebService.phpdir/index.php";
		var cnx = haxe.remoting.HttpAsyncConnection.urlConnect(url);
		call...
	}
*/		
	static function loadThemes()
	{
		var url = PDFGUI_WEBSERVICE_URL;
		var cnx = haxe.remoting.HttpAsyncConnection.urlConnect(url);
		cnx.Service.listThemes.call([], callbackLoadThemes);
	}

	
	static function callbackLoadThemes(res : Array<String>)
	{
		//Clear what's already in
		themeNameEl.innerHTML = "<option value=''>(no theme)</option>";
		for(publication in res)
		{
			var option = Lib.document.createElement("option");
			option.setAttribute("value", publication);
			option.innerHTML = StringTools.htmlEscape(publication);
			themeNameEl.appendChild(option);
		}
	}
	
	/**
	*  Gets the list of PDF files from server
	*/
	static function loadPdfFiles()
	{
		var url = PDFGUI_WEBSERVICE_URL;
		var cnx = haxe.remoting.HttpAsyncConnection.urlConnect(url);
		//Write a loading message
		pathToFileEl.innerHTML = "<option>Loading...</option>";
		pathToFileEl.disabled = true;
		cnx.setErrorHandler(js.Lib.alert);
		cnx.Service.listPdfFiles.call([], callbackLoadPdfFiles);
	}
	
	static function callbackLoadPdfFiles(res : Array<String>)
	{
		//Reenable field
		pathToFileEl.innerHTML = "";
		pathToFileEl.disabled = false;
		for(pdf in res)
		{
			var option = Lib.document.createElement("option");
			option.setAttribute("value", pdf);
			option.innerHTML = StringTools.htmlEscape(pdf);
			pathToFileEl.appendChild(option);
		}
	}
}
/**
*  Defines the two possible modes of the module, either standalone or plugin
*/
enum InterfaceMode {
	standalone;
	plugin;
}
