import org.silex.pdf2swf.PDF2SWFConverter;
import org.silex.serverApi.ServerConfig;
import org.silex.serverApi.ConfigEditor;
import org.silex.serverApi.FileSystemTools;
import org.silex.serverApi.helpers.Env;

class PDF2SWF
{
	public function new()
	{
		
	}

	public static function main(): Void
	{
		var m: PDF2SWF = new PDF2SWF();
		untyped __call__("chdir", "../../..");
//		untyped __call__("session_start");
		Env.setIncludePath(Env.getIncludePath() + Env.pathSeparator + "cgi/library");
		
		//Load plugins config
		var pluginsConfig = new ConfigEditor().readConfigFile(new ServerConfig().silexServerIni.get("SILEX_PLUGINS_CONF"), "phparray");

		
		//Those are some default options
		var opt : org.silex.pdf2swf.ConverterOptions;
		opt =
		{
			leftPageXOffset : 0.0,
			leftPageYOffset : 0.0,
			pageWidth : 512.0,
			pageHeight : 768.0,
			rightPageXOffset : 512.0,
			rightPageYOffset : 0.0,
			namePrefix : "catalogue",
			swfDirectoryName : "./contents/myPubHor/swfs",
			publicationName : "myPubHor",
			previewFormat : org.silex.pdf2swf.PreviewFormats.png,
			hasCover : false,
			hasDoublePages : false,
			pageName : "page",
			pathToSWFTools : ""
		};
		
		//Replacing defaults values with the one from request
		if(php.Web.getParams().get("leftPageXOffset") != "") opt.leftPageXOffset = Std.parseFloat(php.Web.getParams().get("leftPageXOffset"));
		if(php.Web.getParams().get("leftPageYOffset") != "") opt.leftPageYOffset = Std.parseFloat(php.Web.getParams().get("leftPageYOffset"));
		if(php.Web.getParams().get("rightPageXOffset") != "") opt.rightPageXOffset = Std.parseFloat(php.Web.getParams().get("rightPageXOffset"));
		if(php.Web.getParams().get("rightPageYOffset") != "") opt.rightPageYOffset = Std.parseFloat(php.Web.getParams().get("rightPageYOffset"));
		if(php.Web.getParams().get("pageWidth") != "") opt.pageWidth = Std.parseFloat(php.Web.getParams().get("pageWidth"));
		if(php.Web.getParams().get("pageHeight") != "") opt.pageHeight = Std.parseFloat(php.Web.getParams().get("pageHeight"));
		if(php.Web.getParams().get("namePrefix") != "") opt.namePrefix = php.Web.getParams().get("namePrefix");
		if(php.Web.getParams().get("swfDirectoryName") != "") opt.swfDirectoryName = php.Web.getParams().get("swfDirectoryName");
		if(php.Web.getParams().get("publicationName") != "") opt.publicationName = php.Web.getParams().get("publicationName");
		if(php.Web.getParams().get("hasCover") != "") opt.hasCover = if(php.Web.getParams().get("hasCover") == "true") true; else false;
		if(php.Web.getParams().get("hasDoublePages") != "") opt.hasDoublePages = if(php.Web.getParams().get("hasDoublePages") == "true") true; else false;
		if(php.Web.getParams().get("pageName") != "") opt.pageName = php.Web.getParams().get("pageName");
		//if(php.Web.getParams().get("pathToSWFTools") != "") opt.pathToSWFTools = php.Web.getParams().get("pathToSWFTools");
		if(pluginsConfig.get("pathToSWFTools") != null) opt.pathToSWFTools = pluginsConfig.get("pathToSWFTools");


		var fst = new FileSystemTools();
		
		//Setting PATH env variable to know where to look for swftools
		
		switch(php.Web.getParams().get("action"))
		{
			case "convertPage":
				if(php.Web.getParams().get("page") == "" || php.Web.getParams().get("page") == null)
				{
					php.Lib.println("Error");
				}
				var toReturn = org.silex.pdf2swf.PDF2SWFConverter.generatePageSWF(php.Web.getParams().get("pdfFile"), opt, Std.parseInt(php.Web.getParams().get("page")));
				var msg;
				switch(toReturn)
				{
					case PageDoesNotExist:
						php.Lib.print("PageDoesNotExist");
					case Done(msg):
						php.Lib.print("Done " + msg);
					case Error(msg):
						php.Lib.print("Error " + msg);
				}
			case "generatePublicationStructure":
				//Check params
				if(php.Web.getParams().get("startPage") == "" || php.Web.getParams().get("startPage") == null)
				{
					php.Lib.println("Error");
				}
				
				if(php.Web.getParams().get("silexPage") == "" || php.Web.getParams().get("silexPage") == null)
				{
					php.Lib.println("Error");
				}
				
				var toReturn = org.silex.pdf2swf.PDF2SWFConverter.generatePublication(opt, Std.parseInt(php.Web.getParams().get("pageNumber")),
														Std.parseInt(php.Web.getParams().get("startPage")),
														Std.parseInt(php.Web.getParams().get("silexPage")),
														php.Web.getParams().get("layerName"),
														php.Web.getParams().get("importFormat"));
				switch(toReturn)
				{
					case Done(msg):
						php.Lib.print(msg);
					case Error(msg):
						php.Lib.print("Error " + msg);
					case PageDoesNotExist:
				}
		}
		
//		org.silex.pdf2swf.PDF2SWFConverter.convertFile("/Users/dasnoisbenjamin/Documents/catalogue.pdf", opt);
	}
	
	private static function sanitizeOptions(opt : org.silex.pdf2swf.ConverterOptions)
	{
		if(opt.hasDoublePages)
			opt.hasCover = false;
		return opt;
	}
}
