<?php

class org_silex_publication_LayerParser {
	public function __construct(){}
	static function layer2XML($layer) {
		$xml = Xml::createDocument();
		$layerNode = Xml::createElement("layer");
		$xml->addChild($layerNode);
		$subNode = Xml::createElement("subLayers");
		$layerNode->addChild($subNode);
		if(null == $layer->subLayers) throw new HException('null iterable');
		$it = $layer->subLayers->iterator();
		while($it->hasNext()) {
		$subLayer = $it->next();
		{
			$subLayerNode = Xml::createElement("subLayer");
			$subLayerNode->set("id", $subLayer->id);
			$subLayerNode->set("zIndex", Std::string($subLayer->zIndex));
			$componentsNode = Xml::createElement("components");
			if(null == $subLayer->components) throw new HException('null iterable');
			$it2 = $subLayer->components->iterator();
			while($it2->hasNext()) {
			$comp = $it2->next();
			{
				$compNode = Xml::createElement("component");
				$metaNode = Xml::createElement("metaData");
				$compNode->addChild($metaNode);
				if(null == $comp->metaData) throw new HException('null iterable');
				$it3 = $comp->metaData->keys();
				while($it3->hasNext()) {
				$prop = $it3->next();
				{
					$metaNode->addChild(org_silex_publication_LayerParser::generateXml($comp->metaData->get($prop), $prop));
					;
				}
				}
				$propNode = Xml::createElement("properties");
				$compNode->addChild($propNode);
				if(null == $comp->properties) throw new HException('null iterable');
				$it3 = $comp->properties->keys();
				while($it3->hasNext()) {
				$prop = $it3->next();
				{
					$propNode->addChild(org_silex_publication_LayerParser::generateXml($comp->properties->get($prop), $prop));
					;
				}
				}
				$actionsNode = Xml::createElement("actions");
				$compNode->addChild($actionsNode);
				if(null == $comp->actions) throw new HException('null iterable');
				$it3 = $comp->actions->iterator();
				while($it3->hasNext()) {
				$action = $it3->next();
				{
					$actionNode = Xml::createElement("action");
					$actionNode->addChild(org_silex_publication_LayerParser::generateXml($action->functionName, "functionName"));
					$actionNode->addChild(org_silex_publication_LayerParser::generateXml($action->modifier, "modifier"));
					$parametersNode = Xml::createElement("parameters");
					if(null == $action->parameters) throw new HException('null iterable');
					$it4 = $action->parameters->iterator();
					while($it4->hasNext()) {
					$parameter = $it4->next();
					{
						$parametersNode->addChild(org_silex_publication_LayerParser::generateXml($parameter, "parameter"));
						;
					}
					}
					$actionNode->addChild($parametersNode);
					$actionsNode->addChild($actionNode);
					unset($parametersNode,$actionNode);
				}
				}
				$componentsNode->addChild($compNode);
				unset($propNode,$metaNode,$compNode,$actionsNode);
			}
			}
			$subLayerNode->addChild($componentsNode);
			$subNode->addChild($subLayerNode);
			unset($subLayerNode,$componentsNode);
		}
		}
		return $xml;
		unset($xml,$subNode,$layerNode);
	}
	static function xml2Layer($xml) {
		$layer = new org_silex_publication_LayerModel();
		if($xml->firstElement()->elementsNamed("subLayers")->hasNext()) {
			if(null == $xml->firstElement()->elementsNamed("subLayers")->next()) throw new HException('null iterable');
			$it = $xml->firstElement()->elementsNamed("subLayers")->next()->elementsNamed("subLayer");
			while($it->hasNext()) {
			$subNode = $it->next();
			{
				$subLayer = new org_silex_publication_SubLayerModel();
				$subLayer->id = $subNode->get("id");
				$subLayer->zIndex = Std::parseInt($subNode->get("zIndex"));
				if($subNode->elementsNamed("components")->hasNext()) {
					if(null == $subNode->elementsNamed("components")->next()) throw new HException('null iterable');
					$it2 = $subNode->elementsNamed("components")->next()->elementsNamed("component");
					while($it2->hasNext()) {
					$componentNode = $it2->next();
					{
						$comp = new org_silex_publication_ComponentModel();
						if($componentNode->elementsNamed("properties")->hasNext()) {
							if(null == $componentNode->elementsNamed("properties")->next()) throw new HException('null iterable');
							$it3 = $componentNode->elementsNamed("properties")->next()->elements();
							while($it3->hasNext()) {
							$prop = $it3->next();
							{
								$comp->properties->set($prop->getNodeName(), org_silex_publication_LayerParser::parseObject($prop));
								;
							}
							}
							;
						}
						if($componentNode->elementsNamed("metaData")->hasNext()) {
							if(null == $componentNode->elementsNamed("metaData")->next()) throw new HException('null iterable');
							$it3 = $componentNode->elementsNamed("metaData")->next()->elements();
							while($it3->hasNext()) {
							$prop = $it3->next();
							{
								$comp->metaData->set($prop->getNodeName(), org_silex_publication_LayerParser::parseObject($prop));
								;
							}
							}
							;
						}
						if($componentNode->elementsNamed("actions")->hasNext()) {
							if(null == $componentNode->elementsNamed("actions")->next()) throw new HException('null iterable');
							$it3 = $componentNode->elementsNamed("actions")->next()->elementsNamed("action");
							while($it3->hasNext()) {
							$actionNode = $it3->next();
							{
								$actionModel = new org_silex_publication_ActionModel();
								$actionModel->functionName = $actionNode->elementsNamed("functionName")->next()->firstChild()->toString();
								$actionModel->modifier = $actionNode->elementsNamed("modifier")->next()->firstChild()->toString();
								if(null == $actionNode->elementsNamed("parameters")->next()) throw new HException('null iterable');
								$it4 = $actionNode->elementsNamed("parameters")->next()->elementsNamed("parameter");
								while($it4->hasNext()) {
								$parameterNode = $it4->next();
								{
									$actionModel->parameters->add($parameterNode->firstChild()->toString());
									;
								}
								}
								$comp->actions->add($actionModel);
								unset($actionModel);
							}
							}
							;
						}
						$subLayer->components->add($comp);
						unset($comp);
					}
					}
					;
				}
				$layer->subLayers->add($subLayer);
				unset($subLayer);
			}
			}
			;
		}
		return $layer;
		unset($layer);
	}
	static function parseObject($node) {
		switch($node->get("type")) {
		case null:{
			return $node->firstChild()->getNodeValue();
			;
		}break;
		case "Int":{
			return Std::parseInt($node->firstChild()->getNodeValue());
			;
		}break;
		case "Float":{
			return Std::parseFloat($node->firstChild()->getNodeValue());
			;
		}break;
		case "Array":{
			$arr = new _hx_array(array());
			if(null == $node) throw new HException('null iterable');
			$it = $node->elementsNamed("item");
			while($it->hasNext()) {
			$item = $it->next();
			{
				$arr->push(org_silex_publication_LayerParser::parseObject($item));
				;
			}
			}
			return $arr;
			unset($arr);
		}break;
		case "Object":{
			$hashTable = new Hash();
			if(null == $node) throw new HException('null iterable');
			$it = $node->elements();
			while($it->hasNext()) {
			$el = $it->next();
			{
				$hashTable->set($el->getNodeName(), org_silex_publication_LayerParser::parseObject($el));
				;
			}
			}
			return $hashTable;
			unset($hashTable);
		}break;
		default:{
			return $node->firstChild()->getNodeValue();
			;
		}break;
		}
		return null;
		;
	}
	static function generateXml($obj, $name) {
		$e = Xml::createElement($name);
		if(Std::is($obj, _hx_qtype("String"))) {
			$n = Xml::createPCData($obj);
			$e->addChild($n);
			return $e;
			unset($n);
		}
		else {
			if(Std::is($obj, _hx_qtype("Int"))) {
				$e->set("type", "Integer");
				$n = Xml::createPCData(Std::string($obj));
				$e->addChild($n);
				return $e;
				unset($n);
			}
			else {
				if(Std::is($obj, _hx_qtype("Float"))) {
					$e->set("type", "Float");
					$n = Xml::createPCData(Std::string($obj));
					$e->addChild($n);
					return $e;
					unset($n);
				}
				else {
					if(Std::is($obj, _hx_qtype("Array"))) {
						$e->set("type", "Array");
						{
							$_g = 0; $_g1 = _hx_cast($obj, _hx_qtype("Array"));
							while($_g < $_g1->length) {
								$item = $_g1[$_g];
								++$_g;
								$n = org_silex_publication_LayerParser::generateXml($item, "item");
								$e->addChild($n);
								unset($n,$item);
							}
							unset($_g1,$_g);
						}
						return $e;
						;
					}
					else {
						if(Std::is($obj, _hx_qtype("Hash"))) {
							$e->set("type", "Object");
							if(null == _hx_cast($obj, _hx_qtype("Hash"))) throw new HException('null iterable');
							$it = _hx_cast($obj, _hx_qtype("Hash"))->keys();
							while($it->hasNext()) {
							$k = $it->next();
							{
								$n = org_silex_publication_LayerParser::generateXml($obj->get($k), $k);
								$e->addChild($n);
								unset($n);
							}
							}
							return $e;
							;
						}
						;
					}
					;
				}
				;
			}
			;
		}
		return null;
		unset($e);
	}
	function __toString() { return 'org.silex.publication.LayerParser'; }
}
