<?php
// This script handles file upload with enhanced functionalities
// detailled functionalities:
//  -handles most error messages with nice formatting
//  -checks if the file extension is in the $ALLOWED_EXTENSIONS array
//  -removes special characters from the destination file name
//  -if wanted destination file name is already existing, changes it to $fileNamePrefix.++i.$fileNameExtension

// init constants
// Base directory
define ("BASE_DIR", "../../");
// Destination directory
define ("MEDIA_DIR", "media/");
// Allowed extensions array
$ALLOWED_EXTENSIONS = array('pdf');

// Print upload ok message
function print_upload_ok($str) {
	echo '<font color="#009900"><strong>'.$str.'</strong></font>';
}

// Print error message
function print_error($str) {
	echo '<font color="#C80000"><strong>'.$str.'</strong></font>';
}

// Handles upload error message if any
function file_upload_error_message($error_code) {
    switch ($error_code) {
        case UPLOAD_ERR_INI_SIZE:
            return 'File exceeds upload_max_filesize value ('.ini_get('upload_max_filesize').') in php.ini or .htaccess';
        case UPLOAD_ERR_FORM_SIZE:
            return 'File exceeds the MAX_FILE_SIZE value ('.display_filesize($_POST['MAX_FILE_SIZE']).') specified in the HTML form';
        case UPLOAD_ERR_PARTIAL:
            return 'File was only partially uploaded';
        case UPLOAD_ERR_NO_FILE:
            return 'No file was uploaded. Please select a file.';
        case UPLOAD_ERR_NO_TMP_DIR:
            return 'Missing a temporary folder';
        case UPLOAD_ERR_CANT_WRITE:
            return 'Failed to write file to disk';
        case UPLOAD_ERR_EXTENSION:
            return 'File upload stopped by extension';
        default:
            return 'Unknown upload error';
    }
}

// Checks if extension is valid 
function isAllowedExtension($fileName) {
	global $ALLOWED_EXTENSIONS;
	return in_array(end(explode(".", strtolower($fileName))),$ALLOWED_EXTENSIONS);
}

// Converts filesize to a more legible format (from bits to 'Byte','KB','MB','GB','TB' or 'PB' depending on the size)
function display_filesize($filesize){
    if(is_numeric($filesize)){
		$decr = 1024; $step = 0;
		$prefix = array('Byte','KB','MB','GB','TB','PB');
		   
		while(($filesize / $decr) > 0.9){
			$filesize = $filesize / $decr;
			$step++;
		}
		return round($filesize,2).' '.$prefix[$step];
    } else {
		return 'NaN';
    }
}

// Creates a valid filename by removing special characters
function reformat_filename($str) {
	$allowed = "/[^a-z0-9\\-\\_\\.]/i";
	return preg_replace($allowed,"",$str);
}


// MAIN

// If there is no post_max_size limitation
if (!empty($_FILES)) {

// If file was correctly uploaded
	if ($_FILES['userfile']['error'] === UPLOAD_ERR_OK) {

	// If file has a valid extension
		if(isAllowedExtension($_FILES['userfile']['name'])) {

			// Removes special characters from filename
			$reformatedFileName = reformat_filename($_FILES['userfile']['name']);
			
			// If destination file already exists, change the destination file name to $fileNamePrefix.++i.$fileNameExtension
			if(file_exists(BASE_DIR.MEDIA_DIR.$reformatedFileName)) {
				// Gets file name extension
				$fileNameExtension = end(explode(".", $reformatedFileName));
				// Gets file name prefix without dot '.'
				$fileNamePrefix = substr($reformatedFileName,0,strlen($reformatedFileName)-strlen($fileNameExtension)-1);
				$tempFileName = $reformatedFileName;
				$i = 0;
				// As long as the filename still exists, increment i
				while(file_exists(BASE_DIR . MEDIA_DIR . $tempFileName)) {
					$tempFileName = $fileNamePrefix . ++$i . '.' . $fileNameExtension;
				}
				$destinationFileName = $tempFileName;
			} else {
				$destinationFileName = $reformatedFileName;
			}
			
			// Construct destination path with new filename
			$path = BASE_DIR.MEDIA_DIR.$destinationFileName;

			// If file copy is successful
			if(move_uploaded_file($_FILES['userfile']['tmp_name'], $path)){ 

				//Get file size
				$theFileSize = display_filesize($_FILES['userfile']['size']);

				print_upload_ok('Upload Successful - File Size: '.$theFileSize);

				echo '<script language="javascript">
					parent.returnValue("' . MEDIA_DIR . $destinationFileName . '")
				</script>';

				// If file copy is not successful
			} else {
				print_error('File could not be moved');
			}
		}

		// if file has an invalid extension
		else {
			//echo "Invalid file type";
			print_error('Invalid file type');
		}
	}

	// If file was not correctly uploaded
	else {
		print_error(file_upload_error_message($_FILES['userfile']['error']));
	}
}

// If there is a post_max_size limitation
else {
	print_error('File exceeds the post_max_size value ('.ini_get('post_max_size').') in php.ini or .htaccess');
}

?>
