<?php
/*
 This file is part of Silex: RIA developement tool - see http://silex-ria.org/

Silex is (c) 2007-2012 Silex Labs and is released under the GPL License:

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License (GPL) as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

To read the license please visit http://www.gnu.org/copyleft/gpl.html
*/
// include './rootdir.php'; we do not call rootdir.php for the moment as it's already within the filepath. Also this includes seems to break the administration part of the plugin. If we notice some cases where ROOTPATH isn't known when we call index.php, we will have to rethink this part.
require_once ROOTPATH.'cgi/includes/plugin_base.php';

class pdfImport extends plugin_base
{
	protected $pluginScope = 4;
	
	function initDefaultParamTable()
	{
		$this->paramTable = array( 
			array(
				"name" => "pathToSWFTools",
				"label" => "Path to SWFTools",
				"description" => "This is the path to SWFTools",
				"value" => "",
				"restrict" => "",
				"type" => "string",
				"maxChars" => "1000"
			)
		);
	}
	
	public function getDescription()
	{
		return "Import a PDF.";
	}

	/**
	* Returns the html code corresponding to the administration page of the plugin.
	* In that case, we call the create_website_index.php script of the search plugin passing the site name in parameter
	* @return string
	*/
	public function getAdminPage($siteName)
	{
		$result1 = file_get_contents("../../plugins/pdfImport/interface.html");
		$result2 = str_replace( '%upLoadString%' , '<button id="openFTP" class="orangeButton">Upload a PDF</button>' , $result1 );
		$result3 = str_replace( '%refreshString%' , '<td><button id="refreshPDFList">Refresh</button></td>' , $result2 );
		$finalResult = str_replace( '%pluginURL%' , 'plugins/pdfImport/' , $result3 );
		return $finalResult;
	}
	
}

?>
