<?php

class php_net_Socket {
	public function __construct($s) {
		if( !php_Boot::$skip_constructor ) {
		$this->__s = $s;
		$this->input = new php_io_FileInput($this->__s);
		$this->output = new php_io_FileOutput($this->__s);
		$this->protocol = "tcp";
		;
	}}
	public $__s;
	public $input;
	public $output;
	public $custom;
	public $protocol;
	public function assignHandler() {
		$this->input->__f = $this->__s;
		$this->output->__f = $this->__s;
		;
	}
	public function close() {
		fclose($this->__s);
		{
			$this->input->__f = null;
			$this->output->__f = null;
			;
		}
		$this->input->close();
		$this->output->close();
		;
	}
	public function read() {
		$b = "";
		while (!feof($this->__s)) $b .= fgets($this->__s);
		return $b;
		unset($b);
	}
	public function write($content) {
		fwrite($this->__s, $content);
		return;
		;
	}
	public function connect($host, $port) {
		$errs = null;
		$errn = null;
		$r = stream_socket_client(((($this->protocol . "://") . $host->_ip) . ":") . $port, $errn, $errs);
		php_net_Socket::checkError($r, $errn, $errs);
		$this->__s = $r;
		$this->assignHandler();
		unset($r,$errs,$errn);
	}
	public function listen($connections) {
		;
		;
	}
	public function shutdown($read, $write) {
		$r = null;
		if(function_exists("stream_socket_shutdown")) {
			$rw = php_net_Socket_0($this, $r, $read, $write);
			$r = stream_socket_shutdown($this->__s, $rw);
			unset($rw);
		}
		else {
			$r = fclose($this->__s);
			;
		}
		php_net_Socket::checkError($r, 0, "Unable to Shutdown");
		unset($r);
	}
	public function bind($host, $port) {
		$errs = null;
		$errn = null;
		$r = stream_socket_server(((($this->protocol . "://") . $host->_ip) . ":") . $port, $errn, $errs, php_net_Socket_1($this, $errn, $errs, $host, $port));
		php_net_Socket::checkError($r, $errn, $errs);
		$this->__s = $r;
		$this->assignHandler();
		unset($r,$errs,$errn);
	}
	public function accept() {
		$r = stream_socket_accept($this->__s);
		php_net_Socket::checkError($r, 0, "Unable to accept connections on socket");
		return new php_net_Socket($r);
		unset($r);
	}
	public function hpOfString($s) {
		$parts = _hx_explode(":", $s);
		if($parts->length === 2) {
			return _hx_anonymous(array("host" => new php_net_Host($parts[0]), "port" => Std::parseInt($parts[1])));
			;
		}
		else {
			return _hx_anonymous(array("host" => new php_net_Host(_hx_substr($parts[1], 2, null)), "port" => Std::parseInt($parts[2])));
			;
		}
		unset($parts);
	}
	public function peer() {
		$r = stream_socket_get_name($this->__s, true);
		php_net_Socket::checkError($r, 0, "Unable to retrieve the peer name");
		return $this->hpOfString($r);
		unset($r);
	}
	public function host() {
		$r = stream_socket_get_name($this->__s, false);
		php_net_Socket::checkError($r, 0, "Unable to retrieve the host name");
		return $this->hpOfString($r);
		unset($r);
	}
	public function setTimeout($timeout) {
		$s = intval($timeout);
		$ms = intval(($timeout - $s) * 1000000);
		$r = stream_set_timeout($this->__s, $s, $ms);
		php_net_Socket::checkError($r, 0, "Unable to set timeout");
		unset($s,$r,$ms);
	}
	public function setBlocking($b) {
		$r = stream_set_blocking($this->__s, $b);
		php_net_Socket::checkError($r, 0, "Unable to block");
		unset($r);
	}
	public function __call($m, $a) {
		if(isset($this->$m) && is_callable($this->$m))
			return call_user_func_array($this->$m, $a);
		else if(isset($this->dynamics[$m]) && is_callable($this->dynamics[$m]))
			return call_user_func_array($this->dynamics[$m], $a);
		else if('toString' == $m)
			return $this->__toString();
		else
			throw new HException('Unable to call '.$m.'');
	}
	static function newUdpSocket() {
		$s = new php_net_Socket(null);
		$s->protocol = "udp";
		return $s;
		unset($s);
	}
	static function newSslSocket() {
		$s = new php_net_Socket(null);
		$s->protocol = "ssl";
		return $s;
		unset($s);
	}
	static function checkError($r, $code, $msg) {
		if(!$r === false) {
			return;
			;
		}
		throw new HException(haxe_io_Error::Custom((("Error [" . $code) . "]: ") . $msg));
		;
	}
	static function getType($isUdp) {
		return php_net_Socket_2($isUdp);
		;
	}
	static function getProtocol($protocol) {
		return getprotobyname($protocol);
		;
	}
	function __toString() { return 'php.net.Socket'; }
}
;
function php_net_Socket_0(&$this, &$r, &$read, &$write) {
if($read && $write) {
	return 2;
	;
}
else {
	return (php_net_Socket_3($r, $read, $write));
	;
}
}
function php_net_Socket_1(&$this, &$errn, &$errs, &$host, &$port) {
if($this->protocol === "udp") {
	return STREAM_SERVER_BIND;
	;
}
else {
	return STREAM_SERVER_BIND | STREAM_SERVER_LISTEN;
	;
}
}
function php_net_Socket_2(&$isUdp) {
if($isUdp) {
	return SOCK_DGRAM;
	;
}
else {
	return SOCK_STREAM;
	;
}
}
function php_net_Socket_3(&$r, &$read, &$write) {
if($write) {
	return 1;
	;
}
else {
	return (php_net_Socket_4($r, $read, $write));
	;
}
}
function php_net_Socket_4(&$r, &$read, &$write) {
if($read) {
	return 0;
	;
}
else {
	return 2;
	;
}
}