<?php

class org_silex_pdf2swf_PDF2SWFConverter {
	public function __construct(){}
	static $NORMAL_PAGES = "template_import_pdf.xml";
	static $FIRST_PAGE = "template_import_pdf_first_page.xml";
	static $LAST_PAGE = "template_import_pdf_last_page.xml";
	static $LEFT_COMPONENT = "template_left_page_pdf";
	static $RIGHT_COMPONENT = "template_right_page_pdf";
	static function generatePageSWF($pathToFile, $options, $pageNumber) {
		org_silex_pdf2swf_PDF2SWFConverter::createDirPath($options->swfDirectoryName);
		set_include_path(((get_include_path() . ":") . php_Sys::getCwd()) . "cgi/library");
		require_once(php_Sys::getCwd() . "cgi/includes/file_system_tools.php");
		require_once(php_Sys::getCwd() . "cgi/includes/server_config.php");
		$serverConfig = new server_config();
		$contentFolder = null;
		$contentFolder = $serverConfig->getContentFolderForPublication($options->publicationName);
		$workingDirectory = getcwd();
		session_start();
		$cl = new org_silex_serverApi_FileSystemTools();
		org_silex_pdf2swf_PDF2SWFConverter::debug("New run.");
		org_silex_pdf2swf_PDF2SWFConverter::debug("Working directory is " . getcwd());
		$swfDirectoryName = $cl->sanitize($options->swfDirectoryName, true);
		if(!$cl->checkRights($swfDirectoryName, org_silex_serverApi_FileSystemTools::getAdminRole(), org_silex_serverApi_FileSystemTools::getWriteAction())) {
			return org_silex_pdf2swf_ReturnCode::Error("Not enough rights to generate page");
			;
		}
		$proc = new php_io_Process(org_silex_pdf2swf_PDF2SWFConverter::concatPath($options->pathToSWFTools, "pdf2swf"), new _hx_array(array(org_silex_pdf2swf_PDF2SWFConverter::concatPath($workingDirectory, $pathToFile), "-s", "poly2bitmap", "-s", "zoom=100", "-j 60", "-p", Std::string($pageNumber), "-o", org_silex_pdf2swf_PDF2SWFConverter::concatPath($workingDirectory, (($options->swfDirectoryName . "/") . $options->namePrefix) . "%.swf"))));
		$pagePDF = null;
		$line = "";
		$nbLines = 0;
		try {
			while(true) {
				$line = $proc->stdout->readLine();
				org_silex_pdf2swf_PDF2SWFConverter::debug($line);
				$nbLines++;
				if(_hx_index_of($line, "NOTICE  processing PDF page ", null) === 0) {
					$pagePDF = Std::parseInt(_hx_array_get(_hx_explode(" ", $line), 5));
					;
				}
				;
			}
			;
		}catch(Exception $e) {
		$_ex_ = ($e instanceof HException) ? $e->e : $e;
		;
		{ $e = $_ex_;
		{
			if($pagePDF === null && $nbLines === 0) {
				return org_silex_pdf2swf_ReturnCode::Error("PagePDF was null - Make sure SWFTools are available.");
				;
			}
			else {
				if($pagePDF === null) {
					return org_silex_pdf2swf_ReturnCode::$PageDoesNotExist;
					;
				}
				;
			}
			;
		}}}
		if($proc->exitCode() === 0 && $pagePDF === null) {
			return org_silex_pdf2swf_ReturnCode::$PageDoesNotExist;
			;
		}
		if($proc->exitCode() !== 0) {
			return org_silex_pdf2swf_ReturnCode::Error("Bad exitcode");
			;
		}
		new php_io_Process(org_silex_pdf2swf_PDF2SWFConverter::concatPath($options->pathToSWFTools, "swfrender"), new _hx_array(array(org_silex_pdf2swf_PDF2SWFConverter::concatPath($workingDirectory, ((($options->swfDirectoryName . "/") . $options->namePrefix) . $pageNumber) . ".swf"), "-o", org_silex_pdf2swf_PDF2SWFConverter::concatPath($workingDirectory, ((($options->swfDirectoryName . "/") . $options->namePrefix) . $pageNumber) . ".png"))));
		$imgpng = imagecreatefrompng(((($options->swfDirectoryName . "/") . $options->namePrefix) . $pageNumber) . ".png");
		$size = new _hx_array(getimagesize(((($options->swfDirectoryName . "/") . $options->namePrefix) . $pageNumber) . ".png"));
		$imgjpg = imagecreatetruecolor($size[0], $size[1]);
		imagecopy($imgjpg, $imgpng, 0, 0, 0, 0, $size[0], $size[1]);
		imagejpeg($imgjpg, ((($options->swfDirectoryName . "/") . $options->namePrefix) . $pageNumber) . ".jpg", 75);
		@unlink(((($options->swfDirectoryName . "/") . $options->namePrefix) . $pageNumber) . ".png");
		return org_silex_pdf2swf_ReturnCode::Done(((($options->swfDirectoryName . "/") . $options->namePrefix) . $pageNumber) . ".jpg");
		unset($workingDirectory,$swfDirectoryName,$size,$serverConfig,$proc,$pagePDF,$nbLines,$line,$imgpng,$imgjpg,$e,$contentFolder,$cl);
	}
	static function generatePublication($options, $lastPage, $startPage, $silexPageNumber, $layerName, $importFormat) {
		$previewsURL = new HList();
		$templateType = null;
		session_start();
		set_include_path(((get_include_path() . ":") . php_Sys::getCwd()) . "cgi/library");
		require_once(php_Sys::getCwd() . "cgi/includes/server_config.php");
		require_once(php_Sys::getCwd() . "cgi/includes/file_system_tools.php");
		$serverConfig = new server_config();
		$cl = new org_silex_serverApi_FileSystemTools();
		$contentFolder = $serverConfig->getContentFolderForPublication($options->publicationName);
		$contentFolderSanitized = $cl->sanitize($contentFolder, true);
		if(!$cl->checkRights($contentFolderSanitized, org_silex_serverApi_FileSystemTools::getAdminRole(), org_silex_serverApi_FileSystemTools::getWriteAction())) {
			return org_silex_pdf2swf_ReturnCode::Error("Not enough rights to generate publication");
			;
		}
		$importExtension = org_silex_pdf2swf_PDF2SWFConverter_0($cl, $contentFolder, $contentFolderSanitized, $importFormat, $lastPage, $layerName, $options, $previewsURL, $serverConfig, $silexPageNumber, $startPage, $templateType);
		$snapTop = 0;
		$snapLeft = 0;
		$snapWidth = 500;
		$snapHeight = 500;
		$ps = null;
		$ps = new org_silex_publication_PublicationStructureModel();
		$ps->setHasCover($options->hasCover);
		$ps->setHasDoublePages($options->hasDoublePages);
		$ps->recalculatePagesNumbers();
		$pagesLinks = null;
		$pagesLinks = new IntHash();
		{
			$_g1 = $startPage; $_g = $lastPage + 1;
			while($_g1 < $_g) {
				$pn = $_g1++;
				$pagesLinks->set($pn, intval($silexPageNumber) + intval($pn));
				unset($pn);
			}
			unset($_g1,$_g);
		}
		{
			$_g = 1;
			while($_g < $silexPageNumber) {
				$i = $_g++;
				$silexPage = $ps->getPageNumber($i);
				if($silexPage === null) {
					$silexPage = new org_silex_publication_PageModel();
					$ps->pages->push($silexPage);
					$ps->recalculatePagesNumbers();
					$silexPage->name = $options->pageName . $silexPage->pageLeftNumber;
					$silexPage->deeplink = $options->pageName . $silexPage->pageLeftNumber;
					$silexPage->enabled = true;
					;
				}
				unset($silexPage,$i);
			}
			unset($_g);
		}
		if(null == $pagesLinks) throw new HException('null iterable');
		$it = $pagesLinks->keys();
		while($it->hasNext()) {
		$pn = $it->next();
		{
			if($pn === $startPage) {
				$templateType = org_silex_pdf2swf_TemplateType::$FirstPage;
				;
			}
			else {
				if($pn === $lastPage) {
					$templateType = org_silex_pdf2swf_TemplateType::$LastPage;
					;
				}
				else {
					$templateType = org_silex_pdf2swf_TemplateType::$NormalPage;
					;
				}
				;
			}
			$silexPage = $ps->getPageNumber($pagesLinks->get($pn));
			if($silexPage === null) {
				$silexPage = new org_silex_publication_PageModel();
				$ps->pages->push($silexPage);
				$ps->recalculatePagesNumbers();
				$silexPage->name = $options->pageName . $silexPage->pageLeftNumber;
				$silexPage->deeplink = $options->pageName . $silexPage->pageLeftNumber;
				;
			}
			$silexPage->enabled = true;
			$useTemplate = false;
			if(!file_exists(((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".xml") && file_exists((($contentFolder . $options->publicationName) . "/") . "template_import_pdf.xml")) {
				$t = ($templateType);
				switch($t->index) {
				case 0:
				{
					php_io_File::copy((($contentFolder . $options->publicationName) . "/") . "template_import_pdf_first_page.xml", ((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".xml");
					;
				}break;
				case 1:
				{
					php_io_File::copy((($contentFolder . $options->publicationName) . "/") . "template_import_pdf.xml", ((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".xml");
					;
				}break;
				case 2:
				{
					php_io_File::copy((($contentFolder . $options->publicationName) . "/") . "template_import_pdf_last_page.xml", ((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".xml");
					;
				}break;
				}
				;
			}
			$layer = null;
			try {
				$layer = org_silex_publication_LayerParser::xml2Layer(Xml::parse(php_io_File::getContent(((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".xml")));
				;
			}catch(Exception $e) {
			$_ex_ = ($e instanceof HException) ? $e->e : $e;
			;
			{ $e = $_ex_;
			{
				$layer = new org_silex_publication_LayerModel();
				;
			}}}
			$layer->name = $silexPage->name;
			$comp = null;
			$comp = org_silex_pdf2swf_PDF2SWFConverter::findComponentInLayerByName($layer, org_silex_pdf2swf_PDF2SWFConverter_1($cl, $comp, $contentFolder, $contentFolderSanitized, $e, $importExtension, $importFormat, $lastPage, $layer, $layerName, $options, $pagesLinks, $pn, $previewsURL, $ps, $serverConfig, $silexPage, $silexPageNumber, $snapHeight, $snapLeft, $snapTop, $snapWidth, $startPage, $templateType, $useTemplate));
			if($comp !== null) {
				$useTemplate = true;
				;
			}
			if(!$useTemplate) {
				$subLayer = $layer->getSubLayerNamed($layerName);
				if($subLayer === null) {
					$subLayer = new org_silex_publication_SubLayerModel();
					$subLayer->id = $layerName;
					$layer->subLayers->add($subLayer);
					;
				}
				$comp = new org_silex_publication_ComponentModel();
				$comp->properties->set("alpha", 100);
				$comp->properties->set("width", intval($options->pageWidth));
				$comp->properties->set("height", intval($options->pageHeight));
				if($silexPage->pageLeftNumber === $pn) {
					$comp->properties->set("x", intval($options->leftPageXOffset));
					$comp->properties->set("y", intval($options->leftPageYOffset));
					;
				}
				else {
					$comp->properties->set("x", intval($options->rightPageXOffset));
					$comp->properties->set("y", intval($options->rightPageYOffset));
					;
				}
				$comp->className = "org.silex.ui.players.Image";
				$comp->as2Url = "plugins/baseComponents/as2/org.silex.ui.players.Image.swf";
				$comp->html5Url = "html5#org.silex.ui.Image";
				$comp->properties->set("playerName", $options->namePrefix . $pn);
				$comp->properties->set("rotation", 0);
				$comp->properties->set("tabIndex", 1);
				$comp->properties->set("tabEnabled", false);
				$comp->properties->set("visibleOutOfAdmin", true);
				$comp->properties->set("url", ((($options->swfDirectoryName . "/") . $options->namePrefix) . $pn) . $importExtension);
				$comp->properties->set("iconIsDefault", false);
				$comp->properties->set("iconIsIcon", false);
				$comp->properties->set("iconLayoutName", "minimal.swf");
				$comp->properties->set("iconPageName", "new page name");
				$comp->properties->set("fadeInStep", 100);
				$comp->properties->set("tabChildren", false);
				$comp->properties->set("_focusRect", false);
				$comp->properties->set("shadowOffsetY", 10);
				$comp->properties->set("shadowOffsetX", 10);
				$comp->properties->set("shadow", false);
				$comp->properties->set("visibleFrame_bool", false);
				$comp->properties->set("scaleMode", "none");
				$comp->properties->set("useHandCursor", false);
				$comp->properties->set("clickable", true);
				$subLayer->components->add($comp);
				unset($subLayer);
			}
			else {
				$comp->properties->set("url", ((($options->swfDirectoryName . "/") . $options->namePrefix) . $pn) . $importExtension);
				;
			}
			$layer->save("contents/" . $options->publicationName);
			$preview = null;
			if(file_exists(((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".jpg")) {
				$preview = imagecreatefromjpeg(((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".jpg");
				;
			}
			else {
				$layerPrev = org_silex_publication_LayerParser::xml2Layer(Xml::parse(php_io_File::getContent((($contentFolder . $options->publicationName) . "/") . "template_import_pdf.xml")));
				$newWidth = null;
				$newHeight = null;
				$leftComp = org_silex_pdf2swf_PDF2SWFConverter::findComponentInLayerByName($layerPrev, "template_left_page_pdf");
				$rightComp = org_silex_pdf2swf_PDF2SWFConverter::findComponentInLayerByName($layerPrev, "template_right_page_pdf");
				if($ps->hasDoublePages) {
					$newWidth = (intval($rightComp->properties->get("x")) + intval($rightComp->properties->get("width"))) - intval($leftComp->properties->get("x"));
					$newHeight = (intval($rightComp->properties->get("y")) + intval($rightComp->properties->get("height"))) - intval($leftComp->properties->get("y"));
					$snapLeft = intval($leftComp->properties->get("x"));
					$snapTop = intval($leftComp->properties->get("y"));
					;
				}
				else {
					$newWidth = intval($rightComp->properties->get("width"));
					$newHeight = intval($rightComp->properties->get("height"));
					$snapLeft = intval($rightComp->properties->get("x"));
					$snapTop = intval($rightComp->properties->get("y"));
					;
				}
				$preview = imagecreatetruecolor($newWidth, $newHeight);
				unset($rightComp,$newWidth,$newHeight,$leftComp,$layerPrev);
			}
			$imgcomponent = imagecreatefromjpeg(((($options->swfDirectoryName . "/") . $options->namePrefix) . $pn) . ".jpg");
			$size = new _hx_array(getimagesize(((($options->swfDirectoryName . "/") . $options->namePrefix) . $pn) . ".jpg"));
			imagecopyresampled($preview, $imgcomponent, Std::parseInt($comp->properties->get("x")) - $snapLeft, Std::parseInt($comp->properties->get("y")) - $snapTop, 0, 0, $comp->properties->get("width"), $comp->properties->get("height"), $size[0], $size[1]);
			imagejpeg($preview, ((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".jpg", 75);
			if(!Lambda::has($previewsURL, ((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".jpg", null)) {
				$previewsURL->add(((($contentFolder . $options->publicationName) . "/") . $silexPage->name) . ".jpg");
				;
			}
			$importExtension1 = org_silex_pdf2swf_PDF2SWFConverter_2($cl, $comp, $contentFolder, $contentFolderSanitized, $e, $imgcomponent, $importExtension, $importFormat, $lastPage, $layer, $layerName, $options, $pagesLinks, $pn, $preview, $previewsURL, $ps, $serverConfig, $silexPage, $silexPageNumber, $size, $snapHeight, $snapLeft, $snapTop, $snapWidth, $startPage, $templateType, $useTemplate);
			unset($useTemplate,$size,$silexPage,$preview,$layer,$importExtension1,$imgcomponent,$e,$comp);
		}
		}
		try {
			php_io_File::putContent(($contentFolder . $options->publicationName) . "/structure.xml", org_silex_publication_PublicationStructureParser::ps2XML($ps)->toString());
			php_io_File::putContent(($contentFolder . $options->publicationName) . "/structure.published.xml", org_silex_publication_PublicationStructureParser::ps2XML($ps)->toString());
			;
		}catch(Exception $e) {
		$_ex_ = ($e instanceof HException) ? $e->e : $e;
		;
		{ $e = $_ex_;
		{
			return org_silex_pdf2swf_ReturnCode::Error("Couldn't save structure.xml and structure.published.xml");
			;
		}}}
		$returnArray = new _hx_array(array());
		$ps->recalculatePagesNumbers();
		{
			$_g1 = $startPage; $_g = $lastPage + 1;
			while($_g1 < $_g) {
				$pn = $_g1++;
				$returnArray->push((("?/" . $options->publicationName) . "#/") . $ps->getPageNumber($pagesLinks->get($pn))->name);
				unset($pn);
			}
			unset($_g1,$_g);
		}
		return org_silex_pdf2swf_ReturnCode::Done($previewsURL->join("\x0D"));
		unset($templateType,$snapWidth,$snapTop,$snapLeft,$snapHeight,$serverConfig,$returnArray,$ps,$previewsURL,$pagesLinks,$importExtension,$e,$contentFolderSanitized,$contentFolder,$cl);
	}
	static function createDirPath($path) {
		$partialPath = "";
		{
			$_g = 0; $_g1 = _hx_explode("/", $path);
			while($_g < $_g1->length) {
				$s = $_g1[$_g];
				++$_g;
				$partialPath .= $s;
				if(!file_exists($partialPath)) {
					@mkdir($partialPath, 493);
					;
				}
				$partialPath .= "/";
				unset($s);
			}
			unset($_g1,$_g);
		}
		unset($partialPath);
	}
	static function concatPath($path, $command) {
		if($path !== null && $path !== "") {
			if(_hx_char_at($path, strlen($path)) !== "/") {
				return ($path . "/") . $command;
				;
			}
			return $path . $command;
			;
		}
		return $command;
		;
	}
	static function findComponentInLayerByName($layer, $name) {
		if(null == $layer->subLayers) throw new HException('null iterable');
		$it = $layer->subLayers->iterator();
		while($it->hasNext()) {
		$sb = $it->next();
		{
			if(null == $sb->components) throw new HException('null iterable');
			$it2 = $sb->components->iterator();
			while($it2->hasNext()) {
			$comp = $it2->next();
			{
				if(_hx_equal($comp->properties->get("playerName"), $name)) {
					return $comp;
					;
				}
				;
			}
			}
			;
		}
		}
		return null;
		;
	}
	static function debug($msg) {
		;
		;
	}
	function __toString() { return 'org.silex.pdf2swf.PDF2SWFConverter'; }
}
;
function org_silex_pdf2swf_PDF2SWFConverter_0(&$cl, &$contentFolder, &$contentFolderSanitized, &$importFormat, &$lastPage, &$layerName, &$options, &$previewsURL, &$serverConfig, &$silexPageNumber, &$startPage, &$templateType) {
switch($importFormat) {
case "SWF":{
	return ".swf";
	;
}break;
default:{
	return ".jpg";
	;
}break;
}
}
function org_silex_pdf2swf_PDF2SWFConverter_1(&$cl, &$comp, &$contentFolder, &$contentFolderSanitized, &$e, &$importExtension, &$importFormat, &$lastPage, &$layer, &$layerName, &$options, &$pagesLinks, &$pn, &$previewsURL, &$ps, &$serverConfig, &$silexPage, &$silexPageNumber, &$snapHeight, &$snapLeft, &$snapTop, &$snapWidth, &$startPage, &$templateType, &$useTemplate) {
if($silexPage->pageLeftNumber === $pagesLinks->get($pn)) {
	return "template_left_page_pdf";
	;
}
else {
	return "template_right_page_pdf";
	;
}
}
function org_silex_pdf2swf_PDF2SWFConverter_2(&$cl, &$comp, &$contentFolder, &$contentFolderSanitized, &$e, &$imgcomponent, &$importExtension, &$importFormat, &$lastPage, &$layer, &$layerName, &$options, &$pagesLinks, &$pn, &$preview, &$previewsURL, &$ps, &$serverConfig, &$silexPage, &$silexPageNumber, &$size, &$snapHeight, &$snapLeft, &$snapTop, &$snapWidth, &$startPage, &$templateType, &$useTemplate) {
switch($importFormat) {
case "SWF":{
	return @unlink(((($options->swfDirectoryName . "/") . $options->namePrefix) . $pn) . ".jpg");
	;
}break;
default:{
	return _hx_anonymous(array());
	;
}break;
}
}